% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_user_defined_functions}
\alias{glue_get_user_defined_functions}
\title{Retrieves multiple function definitions from the Data Catalog}
\usage{
glue_get_user_defined_functions(CatalogId, DatabaseName, Pattern,
  NextToken, MaxResults)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the functions to be retrieved are
located. If none is provided, the AWS account ID is used by default.}

\item{DatabaseName}{[required] The name of the catalog database where the functions are located.}

\item{Pattern}{[required] An optional function-name pattern string that filters the function
definitions returned.}

\item{NextToken}{A continuation token, if this is a continuation call.}

\item{MaxResults}{The maximum number of functions to return in one response.}
}
\description{
Retrieves multiple function definitions from the Data Catalog.
}
\section{Request syntax}{
\preformatted{svc$get_user_defined_functions(
  CatalogId = "string",
  DatabaseName = "string",
  Pattern = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
