% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_batch_create_partition}
\alias{glue_batch_create_partition}
\title{Creates one or more partitions in a batch operation}
\usage{
glue_batch_create_partition(CatalogId, DatabaseName, TableName,
  PartitionInputList)
}
\arguments{
\item{CatalogId}{The ID of the catalog in which the partition is to be created.
Currently, this should be the AWS account ID.}

\item{DatabaseName}{[required] The name of the metadata database in which the partition is to be
created.}

\item{TableName}{[required] The name of the metadata table in which the partition is to be created.}

\item{PartitionInputList}{[required] A list of \code{PartitionInput} structures that define the partitions to be
created.}
}
\value{
A list with the following syntax:\preformatted{list(
  Errors = list(
    list(
      PartitionValues = list(
        "string"
      ),
      ErrorDetail = list(
        ErrorCode = "string",
        ErrorMessage = "string"
      )
    )
  )
)
}
}
\description{
Creates one or more partitions in a batch operation.
}
\section{Request syntax}{
\preformatted{svc$batch_create_partition(
  CatalogId = "string",
  DatabaseName = "string",
  TableName = "string",
  PartitionInputList = list(
    list(
      Values = list(
        "string"
      ),
      LastAccessTime = as.POSIXct(
        "2015-01-01"
      ),
      StorageDescriptor = list(
        Columns = list(
          list(
            Name = "string",
            Type = "string",
            Comment = "string",
            Parameters = list(
              "string"
            )
          )
        ),
        Location = "string",
        InputFormat = "string",
        OutputFormat = "string",
        Compressed = TRUE|FALSE,
        NumberOfBuckets = 123,
        SerdeInfo = list(
          Name = "string",
          SerializationLibrary = "string",
          Parameters = list(
            "string"
          )
        ),
        BucketColumns = list(
          "string"
        ),
        SortColumns = list(
          list(
            Column = "string",
            SortOrder = 123
          )
        ),
        Parameters = list(
          "string"
        ),
        SkewedInfo = list(
          SkewedColumnNames = list(
            "string"
          ),
          SkewedColumnValues = list(
            "string"
          ),
          SkewedColumnValueLocationMaps = list(
            "string"
          )
        ),
        StoredAsSubDirectories = TRUE|FALSE,
        SchemaReference = list(
          SchemaId = list(
            SchemaArn = "string",
            SchemaName = "string",
            RegistryName = "string"
          ),
          SchemaVersionId = "string",
          SchemaVersionNumber = 123
        )
      ),
      Parameters = list(
        "string"
      ),
      LastAnalyzedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  )
)
}
}

\keyword{internal}
