% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_group}
\alias{quicksight_update_group}
\title{Changes a group description}
\usage{
quicksight_update_group(GroupName, Description, AwsAccountId, Namespace)
}
\arguments{
\item{GroupName}{[required] The name of the group that you want to update.}

\item{Description}{The description for the group that you want to update.}

\item{AwsAccountId}{[required] The ID for the AWS account that the group is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Group = list(
    Arn = "string",
    GroupName = "string",
    Description = "string",
    PrincipalId = "string"
  ),
  RequestId = "string",
  Status = 123
)
}
}
\description{
Changes a group description.
}
\section{Request syntax}{
\preformatted{svc$update_group(
  GroupName = "string",
  Description = "string",
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
