% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_create_studio_session_mapping}
\alias{emr_create_studio_session_mapping}
\title{The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change}
\usage{
emr_create_studio_session_mapping(StudioId, IdentityId, IdentityName,
  IdentityType, SessionPolicyArn)
}
\arguments{
\item{StudioId}{[required] The ID of the Amazon EMR Studio to which the user or group will be
mapped.}

\item{IdentityId}{The globally unique identifier (GUID) of the user or group from the AWS
SSO Identity Store. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserId}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId}{GroupId}
in the \emph{AWS SSO Identity Store API Reference}. Either \code{IdentityName} or
\code{IdentityId} must be specified.}

\item{IdentityName}{The name of the user or group. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserName}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName}{DisplayName}
in the \emph{AWS SSO Identity Store API Reference}. Either \code{IdentityName} or
\code{IdentityId} must be specified.}

\item{IdentityType}{[required] Specifies whether the identity to map to the Studio is a user or a
group.}

\item{SessionPolicyArn}{[required] The Amazon Resource Name (ARN) for the session policy that will be
applied to the user or group. Session policies refine Studio user
permissions without the need to use multiple IAM user roles.}
}
\value{
An empty list.
}
\description{
The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change.

Maps a user or group to the Amazon EMR Studio specified by \code{StudioId},
and applies a session policy to refine Studio permissions for that user
or group.
}
\section{Request syntax}{
\preformatted{svc$create_studio_session_mapping(
  StudioId = "string",
  IdentityId = "string",
  IdentityName = "string",
  IdentityType = "USER"|"GROUP",
  SessionPolicyArn = "string"
)
}
}

\keyword{internal}
