% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_data_set}
\alias{quicksight_create_data_set}
\title{Creates a dataset}
\usage{
quicksight_create_data_set(AwsAccountId, DataSetId, Name,
  PhysicalTableMap, LogicalTableMap, ImportMode, ColumnGroups,
  Permissions, RowLevelPermissionDataSet, ColumnLevelPermissionRules,
  Tags)
}
\arguments{
\item{AwsAccountId}{[required] The AWS account ID.}

\item{DataSetId}{[required] An ID for the dataset that you want to create. This ID is unique per AWS
Region for each AWS account.}

\item{Name}{[required] The display name for the dataset.}

\item{PhysicalTableMap}{[required] Declares the physical tables that are available in the underlying data
sources.}

\item{LogicalTableMap}{Configures the combination and transformation of the data from the
physical tables.}

\item{ImportMode}{[required] Indicates whether you want to import the data into SPICE.}

\item{ColumnGroups}{Groupings of columns that work together in certain QuickSight features.
Currently, only geospatial hierarchy is supported.}

\item{Permissions}{A list of resource permissions on the dataset.}

\item{RowLevelPermissionDataSet}{The row-level security configuration for the data that you want to
create.}

\item{ColumnLevelPermissionRules}{A set of one or more definitions of a
\verb{<a>ColumnLevelPermissionRule</a>}.}

\item{Tags}{Contains a map of the key-value pairs for the resource tag or tags
assigned to the dataset.}
}
\description{
Creates a dataset.
}
\section{Request syntax}{
\preformatted{svc$create_data_set(
  AwsAccountId = "string",
  DataSetId = "string",
  Name = "string",
  PhysicalTableMap = list(
    list(
      RelationalTable = list(
        DataSourceArn = "string",
        Catalog = "string",
        Schema = "string",
        Name = "string",
        InputColumns = list(
          list(
            Name = "string",
            Type = "STRING"|"INTEGER"|"DECIMAL"|"DATETIME"|"BIT"|"BOOLEAN"|"JSON"
          )
        )
      ),
      CustomSql = list(
        DataSourceArn = "string",
        Name = "string",
        SqlQuery = "string",
        Columns = list(
          list(
            Name = "string",
            Type = "STRING"|"INTEGER"|"DECIMAL"|"DATETIME"|"BIT"|"BOOLEAN"|"JSON"
          )
        )
      ),
      S3Source = list(
        DataSourceArn = "string",
        UploadSettings = list(
          Format = "CSV"|"TSV"|"CLF"|"ELF"|"XLSX"|"JSON",
          StartFromRow = 123,
          ContainsHeader = TRUE|FALSE,
          TextQualifier = "DOUBLE_QUOTE"|"SINGLE_QUOTE",
          Delimiter = "string"
        ),
        InputColumns = list(
          list(
            Name = "string",
            Type = "STRING"|"INTEGER"|"DECIMAL"|"DATETIME"|"BIT"|"BOOLEAN"|"JSON"
          )
        )
      )
    )
  ),
  LogicalTableMap = list(
    list(
      Alias = "string",
      DataTransforms = list(
        list(
          ProjectOperation = list(
            ProjectedColumns = list(
              "string"
            )
          ),
          FilterOperation = list(
            ConditionExpression = "string"
          ),
          CreateColumnsOperation = list(
            Columns = list(
              list(
                ColumnName = "string",
                ColumnId = "string",
                Expression = "string"
              )
            )
          ),
          RenameColumnOperation = list(
            ColumnName = "string",
            NewColumnName = "string"
          ),
          CastColumnTypeOperation = list(
            ColumnName = "string",
            NewColumnType = "STRING"|"INTEGER"|"DECIMAL"|"DATETIME",
            Format = "string"
          ),
          TagColumnOperation = list(
            ColumnName = "string",
            Tags = list(
              list(
                ColumnGeographicRole = "COUNTRY"|"STATE"|"COUNTY"|"CITY"|"POSTCODE"|"LONGITUDE"|"LATITUDE",
                ColumnDescription = list(
                  Text = "string"
                )
              )
            )
          )
        )
      ),
      Source = list(
        JoinInstruction = list(
          LeftOperand = "string",
          RightOperand = "string",
          LeftJoinKeyProperties = list(
            UniqueKey = TRUE|FALSE
          ),
          RightJoinKeyProperties = list(
            UniqueKey = TRUE|FALSE
          ),
          Type = "INNER"|"OUTER"|"LEFT"|"RIGHT",
          OnClause = "string"
        ),
        PhysicalTableId = "string"
      )
    )
  ),
  ImportMode = "SPICE"|"DIRECT_QUERY",
  ColumnGroups = list(
    list(
      GeoSpatialColumnGroup = list(
        Name = "string",
        CountryCode = "US",
        Columns = list(
          "string"
        )
      )
    )
  ),
  Permissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  RowLevelPermissionDataSet = list(
    Namespace = "string",
    Arn = "string",
    PermissionPolicy = "GRANT_ACCESS"|"DENY_ACCESS"
  ),
  ColumnLevelPermissionRules = list(
    list(
      Principals = list(
        "string"
      ),
      ColumnNames = list(
        "string"
      )
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
