% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_register_schema_version}
\alias{glue_register_schema_version}
\title{Adds a new version to the existing schema}
\usage{
glue_register_schema_version(SchemaId, SchemaDefinition)
}
\arguments{
\item{SchemaId}{[required] This is a wrapper structure to contain schema identity fields. The
structure contains:
\itemize{
\item SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
Either \code{SchemaArn} or \code{SchemaName} and \code{RegistryName} has to be
provided.
\item SchemaId$SchemaName: The name of the schema. Either \code{SchemaArn} or
\code{SchemaName} and \code{RegistryName} has to be provided.
}}

\item{SchemaDefinition}{[required] The schema definition using the \code{DataFormat} setting for the
\code{SchemaName}.}
}
\description{
Adds a new version to the existing schema. Returns an error if new
version of schema does not meet the compatibility requirements of the
schema set. This API will not create a new schema set and will return a
404 error if the schema set is not already present in the Schema
Registry.

If this is the first schema definition to be registered in the Schema
Registry, this API will store the schema version and return immediately.
Otherwise, this call has the potential to run longer than other
operations due to compatibility modes. You can call the
\code{GetSchemaVersion} API with the \code{SchemaVersionId} to check compatibility
modes.

If the same schema definition is already stored in Schema Registry as a
version, the schema ID of the existing schema is returned to the caller.
}
\section{Request syntax}{
\preformatted{svc$register_schema_version(
  SchemaId = list(
    SchemaArn = "string",
    SchemaName = "string",
    RegistryName = "string"
  ),
  SchemaDefinition = "string"
)
}
}

\keyword{internal}
