% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_update_studio_session_mapping}
\alias{emr_update_studio_session_mapping}
\title{The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change}
\usage{
emr_update_studio_session_mapping(StudioId, IdentityId, IdentityName,
  IdentityType, SessionPolicyArn)
}
\arguments{
\item{StudioId}{[required] The ID of the EMR Studio.}

\item{IdentityId}{The globally unique identifier (GUID) of the user or group. For more
information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserId}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId}{GroupId}
in the \emph{AWS SSO Identity Store API Reference}. Either \code{IdentityName} or
\code{IdentityId} must be specified.}

\item{IdentityName}{The name of the user or group to update. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserName}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName}{DisplayName}
in the \emph{AWS SSO Identity Store API Reference}. Either \code{IdentityName} or
\code{IdentityId} must be specified.}

\item{IdentityType}{[required] Specifies whether the identity to update is a user or a group.}

\item{SessionPolicyArn}{[required] The Amazon Resource Name (ARN) of the session policy to associate with
the specified user or group.}
}
\description{
The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change.

Updates the session policy attached to the user or group for the
specified Amazon EMR Studio.
}
\section{Request syntax}{
\preformatted{svc$update_studio_session_mapping(
  StudioId = "string",
  IdentityId = "string",
  IdentityName = "string",
  IdentityType = "USER"|"GROUP",
  SessionPolicyArn = "string"
)
}
}

\keyword{internal}
