% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_delete_group}
\alias{quicksight_delete_group}
\title{Removes a user group from Amazon QuickSight}
\usage{
quicksight_delete_group(GroupName, AwsAccountId, Namespace)
}
\arguments{
\item{GroupName}{[required] The name of the group that you want to delete.}

\item{AwsAccountId}{[required] The ID for the AWS account that the group is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\description{
Removes a user group from Amazon QuickSight.
}
\details{
The permissions resource is
\code{arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> }.

\strong{CLI Sample:}

\code{aws quicksight delete-group -\\-aws-account-id=111122223333 -\\-namespace=default -\\-group-name=Sales-Management }
}
\section{Request syntax}{
\preformatted{svc$delete_group(
  GroupName = "string",
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
