% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.rimg.r
\name{as.rimg}
\alias{as.rimg}
\alias{is.rimg}
\title{Convert data to an rimg object}
\usage{
as.rimg(object, name = "img")

is.rimg(object)
}
\arguments{
\item{object}{(required) a three-dimensional array containing RGB values.}

\item{name}{the name(s) of the image(s).}
}
\value{
an object of class \code{rimg} for use in further \code{pavo}
functions

a logical value indicating whether the object is of class \code{rimg}
}
\description{
Converts an array containing RGB image data data to an \code{rimg}
object.
}
\examples{
\dontrun{

# Generate some fake image data
fake <- array(c(
as.matrix(rep(c(0.2, 0.4, 0.6), each = 250)),
as.matrix(rep(c(0.4, 0.7, 0.8), each = 250)),
as.matrix(rep(c(0.6, 0.1, 0.2), each = 250))),
dim = c(750, 750, 3))

# Inspect it
head(fakedat)

# Determine if is rimg object
is.rimg(fake)

# Convert to rimg object and check again
fake2 <- as.rimg(fake)
is.rimg(fake2)

}

}
\author{
Thomas E. White \email{thomas.white026@gmail.com}
}
