% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patGMM.R
\name{patGMM}
\alias{patGMM}
\title{Extract colors using GMM clustering (for pre-aligned images).}
\usage{
patGMM(
  sampleList,
  k = 3,
  resampleFactor = NULL,
  maskOutline = NULL,
  plot = FALSE,
  focal = FALSE,
  sigma = 3,
  maskToNA = NULL,
  kmeansOnAll = FALSE
)
}
\arguments{
\item{sampleList}{List of RasterStack objects.}

\item{k}{Integere for defining number of clusters (default = 3).}

\item{resampleFactor}{Integer for downsampling used by \code{\link{redRes}}.}

\item{maskOutline}{When outline is specified, everything outside of the outline will be masked for
the color extraction (default = NULL).}

\item{plot}{Whether to plot transformed color patterns while processing (default = FALSE).}

\item{focal}{Whether to perform Gaussian blurring (default = FALSE).}

\item{sigma}{Size of sigma for Gaussian blurring (default = 3).}

\item{maskToNA}{Replace the color value used for masking (i.e. 0 or 255) with NA.}

\item{kmeansOnAll}{Whether to perform the kmeans clusters on the combined set of pixels of all images
first (default = FALSE).}
}
\value{
List of summed raster for each k-means cluster objects.
}
\description{
Extract colors using GMM clustering (for pre-aligned images).
}
