% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stateSpace.R
\name{stateSpace}
\alias{stateSpace}
\title{State Space Reconstruction}
\usage{
stateSpace(ts, E, tau, verbose = FALSE)
}
\arguments{
\item{ts}{Numeric vector; time series data}

\item{E}{Integer; embedding dimension (E > 1)}

\item{tau}{Integer; time delay (tau > 0)}

\item{verbose}{Logical; whether to display progress information}
}
\value{
An object of class "pc_state" containing:
\itemize{
\item matrix: The reconstructed state space matrix
\item parameters: List of reconstruction parameters
\item original: Original time series data
}
}
\description{
Reconstructs the state space of a time series using delay embedding,
creating a matrix where each row represents a point in the reconstructed space.
}
\details{
State Space Reconstruction Analysis

The function implements Takens' embedding theorem to reconstruct state space:
\itemize{
\item Creates delay vectors using specified embedding dimension (E)
\item Applies time delay (tau) between consecutive elements
\item Handles boundary conditions and missing values
}
}
\section{Related Packages}{

\itemize{
\item \pkg{nonlinearTseries}: Nonlinear time series analysis
\item \pkg{tseriesChaos}: Chaos theory analysis tools
\item \pkg{fractal}: Fractal analysis methods
}
}

\examples{
ts <- c(1:100)
result <- stateSpace(ts, E = 3, tau = 2)
plot(result)

}
