% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{plot.pc_cv}
\alias{plot.pc_cv}
\title{Plot Pattern Causality Cross Validation Results}
\usage{
\method{plot}{pc_cv}(x, fr = FALSE, separate = FALSE, ...)
}
\arguments{
\item{x}{A \code{pc_cv} object.}

\item{fr}{Boolean for frame display.}

\item{separate}{Boolean for separate plots.}

\item{...}{Additional arguments passed to the \code{plot} function.}
}
\value{
Invisibly returns the input object.
}
\description{
Visualizes the pattern causality cross-validation results.
This function generates a line plot showing the causality strengths
for different sample sizes.
}
\examples{
data(climate_indices)
X <- climate_indices$AO
Y <- climate_indices$AAO
numbersets <- c(100, 150, 200)
cv_results <- pcCrossValidation(X, Y, 3, 2, "euclidean", 1, FALSE, numberset = numbersets)
plot(cv_results)
}
