% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{plot.pc_effect}
\alias{plot.pc_effect}
\title{Plot Pattern Causality Effect}
\usage{
\method{plot}{pc_effect}(
  x,
  status = "positive",
  add_label = TRUE,
  point_size = 3,
  label_size = 3,
  ...
)
}
\arguments{
\item{x}{A \code{pc_effect} object.}

\item{status}{Status of the effect to plot ("positive", "negative", or "dark").}

\item{add_label}{Logical, whether to add labels to the plot.}

\item{point_size}{Numeric value for point size (default: 3).}

\item{label_size}{Numeric value for label text size (default: 3).}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
Invisibly returns the ggplot object.
}
\description{
Generates a plot to visualize the effects of positive, negative, or dark
causality. Displays the influence exerted versus influence received for each item.
This function generates a scatter plot showing the influence exerted versus
influence received for each item, colored by the difference between exerted and received influence.
}
\examples{
\donttest{
data(climate_indices)
dataset <- climate_indices[, -1]
pc_matrix_obj <- pcMatrix(dataset, E = 3, tau = 1, 
  metric = "euclidean", h = 1, weighted = TRUE, 
  verbose = FALSE)
effects <- pcEffect(pc_matrix_obj)
plot(effects, status = "positive")
}
}
