% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcCV.R
\name{pcCrossValidation}
\alias{pcCrossValidation}
\title{Pattern Causality Cross-Validation}
\usage{
pcCrossValidation(X, Y, E, tau, metric, h, weighted, numberset)
}
\arguments{
\item{X}{A numeric vector representing the first time series.}

\item{Y}{A numeric vector representing the second time series.}

\item{E}{An integer specifying the embedding dimension for the state space reconstruction.}

\item{tau}{An integer specifying the time delay for the state space reconstruction.}

\item{metric}{A character string specifying the distance metric used in the causality computation (e.g., "euclidean").}

\item{h}{An integer specifying the prediction horizon.}

\item{weighted}{A logical value indicating whether to apply weighted causality measures.}

\item{numberset}{A numeric vector specifying the sample sizes for the cross-validation procedure.}
}
\value{
A data frame containing the aggregated causality metrics across different sample sizes. The data frame includes the positive, negative, and dark causality percentages.
}
\description{
The \code{pcCrossValidation} function performs cross-validation on time series data to evaluate the robustness of pattern causality measures. It repeatedly samples subsets of the data, applies the pattern causality algorithm, and aggregates the results to provide a comprehensive assessment of the causality metrics.
}
\examples{
\donttest{
data(DJS)
X <- DJS$X3M
Y <- DJS$American.Express
numberset <- c(1000,2000,3000,4000)
result <- pcCrossValidation(X,Y,3,2,"euclidean",1,FALSE,numberset)
print(result)
}
}
