% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceMatrix.R
\name{distanceVector}
\alias{distanceVector}
\title{Calculate Distances Between a Reference Point and Multiple Candidates}
\usage{
distanceVector(point, candidateNNs, n)
}
\arguments{
\item{point}{Numeric vector, the reference point from which distances are calculated.}

\item{candidateNNs}{Matrix, rows represent candidate points to which distance from the reference point is calculated.}

\item{n}{Integer, the order of the Minkowski distance to use.}
}
\value{
Numeric vector, distances from the reference point to each of the candidate points.
}
\description{
This function applies the 'metricDistance' function to calculate distances from a given reference point to each row in a matrix of candidate nearest neighbors. It is particularly useful in the situation between matrix and a vector
}
\examples{
point <- c(1, 2, 3)
candidateNNs <- matrix(c(4, 5, 6, 7, 8, 9), nrow = 2, byrow = TRUE)
n <- 2
distances <- distanceVector(point, candidateNNs, n)
print(distances)
}
