% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcAccuracy.R
\name{pcAccuracy}
\alias{pcAccuracy}
\title{PC Accuracy Evaluation Function}
\usage{
pcAccuracy(dataset, E, tau, metric, h, weighted)
}
\arguments{
\item{dataset}{A matrix or data frame where each column represents a time series.}

\item{E}{The embedding dimension used for state space reconstruction.}

\item{tau}{The time delay used in state space reconstruction.}

\item{metric}{A character string specifying the distance metric to be used (e.g., 'euclidean', 'maximum').}

\item{h}{Prediction horizon, indicating how far ahead in the time series the predictions are aimed.}

\item{weighted}{A logical indicating whether to use a weighted approach in calculating the causality strengths.}
}
\value{
A data frame with the embedding parameters and average values of total, positive, negative, and dark causality across all time series pairs in the dataset.
}
\description{
This function evaluates the causality prediction accuracy across multiple time series within a dataset using the PC Mk. II Light method. It checks the feasibility of causality analysis between all pairs, computes different types of causality (total, positive, negative, dark), and aggregates these results.
}
\examples{
\donttest{
data(climate)
data <- climate[, -1]
results <- pcAccuracy(data, E = 3, tau = 1, metric = "euclidean", h = 1, weighted = TRUE)
print(results)
}
}
