% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_subjectProfileCombine.R
\name{subjectProfileCombine}
\alias{subjectProfileCombine}
\title{Combine subject profile plots.}
\usage{
subjectProfileCombine(
  listPlots,
  timeLim = NULL,
  timeAlign = "all",
  timeAlignPerSubject = "none",
  subjectVar = "USUBJID",
  maxNLines = NULL,
  refLines = NULL,
  refLinesData = NULL,
  refLinesTimeVar = NULL,
  refLinesLabelVar = NULL,
  shiny = FALSE,
  verbose = FALSE,
  nCores = 1,
  reportPerSubject = FALSE
)
}
\arguments{
\item{listPlots}{listPlots per subject as created inside the
\code{\link{subjectProfileCombine}} function.}

\item{timeLim}{time limits, as returned by the
\code{\link{getTimeLimSubjectProfilePlots}} function.}

\item{timeAlign}{Character vector with time alignment across modules/subjects, either:
\itemize{
\item{'all' (by default): all plots have the same time limits}
\item{'none': each of the plot (module*subject) has its own time limits}
\item{character vector with names of the modules which
should have the same time limits
(should correspond to the names of \code{listPlots})}
}}

\item{timeAlignPerSubject}{Character vector, specifying if the plots
should be aligned (or not) across subjects
\itemize{
\item{'none' (by default): all modules to align
have the same time limit across subjects}
\item{'all': all modules to align
 have different time limits per subject}
\item{character vector with subset of the modules to align per subject
(should correspond to the names of \code{listPlots})}
}
Only the modules already specified in \code{timeAlign}
can be aligned by subject.}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{maxNLines}{Maximum number of lines for a combined plot,
to fit in the page height. \cr
When the different visualizations
are combined for each subject, they will be allocated 
to different pages if the number of lines of the combined visualization
is higher than this number.}

\item{refLines}{(optional) nested list with details for reference line(s).
Each sublist contains:
\itemize{
\item{(required) 'label': string with label for the reference line}
\item{(required) 'time': unique time (x) coordinate for the reference line}
\item{(optional) 'color': color for the reference line,
'black' by default}
\item{(optional) 'linetype': linetype for the reference line,
'dotted' by default}
}}

\item{refLinesData}{data.frame with data from which the reference line(s) should be extracted}

\item{refLinesTimeVar}{string, variable of \code{refLinesData} with time for reference line(s)}

\item{refLinesLabelVar}{string, variable of \code{refLinesData} with label for reference line(s)}

\item{shiny}{logical, set to TRUE (FALSE by default) 
if the report is generated from a Shiny application.
Messages during report creation will be included in the Shiny interface,
and it will be mentioned at the end of the report.
In this case, the \code{shiny} package should be available.}

\item{verbose}{logical, if TRUE print messages during execution}

\item{nCores}{Integer containing the number of cores used for the computation
(1 by default). If more than 1, computation is parallelized, in this case
the package \code{parallel} is required.}

\item{reportPerSubject}{Logical, if TRUE (FALSE by default)
export a subject profile report by subject.}
}
\value{
a nested list of \code{\link[ggplot2]{ggplot}} object, 
containing the combined
profile plots across modules for each subject/page.\cr
Each plot object contains in the associated attribute:
\code{metaData} containing: \code{nLines}: an estimation
of the number of 'lines' each plot occupies 
(e.g. to set height of the exported figure).
}
\description{
Visualizations of different modules are combined
by subject.
The plots are aligned in the time axis (if requested).
If the plots should be aligned:
\itemize{
\item{the same time limits are set for all plots}
\item{the time axis is transformed if any of the
plot was created with a time transformation}
\item{the time axis is expanded for all plots 
if any of the plot was created with a time axis expanded.\cr
The \code{\link[ggplot2]{expansion}} object for
the combined plot is created 
from the max of each expansion element across modules.}
}
If some plots are missing for a specific subject,
an empty plot is created, containing information
as a text based on the \code{label} with which the plot was created.
}
\author{
Laure Cougnaud
}
