% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{getPageVar}
\alias{getPageVar}
\title{Get variable with page of the plot,
used for automatic paging of a plot}
\usage{
getPageVar(
  data,
  var,
  typeVar = c("y", "panel"),
  formatReport = subjectProfileReportFormat(),
  title = TRUE,
  xLab = TRUE,
  caption = TRUE,
  paging = TRUE,
  table = FALSE
)
}
\arguments{
\item{data}{data.frame with data}

\item{var}{string, variable of \code{data} with variable for the y-axis}

\item{typeVar}{string, type of the variable, either:
'y': the variable is displayed in the x-axis or 
'panel': the variable is displayed as separated facets.
This is used to compute height for each line of the plot.}

\item{formatReport}{list with parameters used to specify the format of the report,
e.g. output of the \code{\link{subjectProfileReportFormat}} function}

\item{title}{logical, has the plot a title?}

\item{xLab}{logical, has the plot a label for the x-axis?}

\item{caption}{logical, has the plot a caption?}

\item{paging}{Logical, if TRUE (by default), automatic 
paging is enabled, so patient profiles module too big to fit
in one page will span multiple pages.
Please note that the size of the graphic window 
(or report page) may need
to be re-sized in order that the plot fits.
\cr
If FALSE, the entire plot is included in one single page.}

\item{table}{Logical, if TRUE the \code{paramValueVar} variables
are displayed as table (so are not concatenated).}
}
\value{
input \code{data} with additional column 'pagePlot'
containing the page for the plot
}
\description{
Get variable with page of the plot,
used for automatic paging of a plot
}
\author{
Laure Cougnaud
}
