% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_by_subject}
\alias{plot_by_subject}
\title{Plot trajectories and density plots of position by subject}
\usage{
plot_by_subject(obj_name, col_by_treat = FALSE, ...)
}
\arguments{
\item{obj_name}{A viewr object (a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) that has been passed
through \code{separate_trajectories()} or \code{get_full_trajectories()}.}

\item{col_by_treat}{If multiple treatments or sessions, color data per
treatment or session. Treatments must be levels in a column named
\code{treatment}.}

\item{...}{Additional arguments passed to/from other pathviewr functions.}
}
\value{
A "bird's eye view" plot and an "elevation view" plot, made via
ggplot2.
}
\description{
Plots all trajectories and generates density plots of position by subject
from elevation and bird's eye views.
}
\details{
The input viewr object should have passed through
\code{separate_trajectories()} or \code{get_full_trajectories()}.
Optionally, treatments should have been added as levels in a column named
\code{treatment}. Two plots will be produced, one from a "bird's eye view"
of width against length and one from an "elevation view" of height against
length. All trajectories will be plotted on a per subject basis, along with
density plots of width or height depending on the view.
\code{col_by_treat = TRUE}, data will be plotted by color according to
treatment in both the trajectory plots and the density plots.
}
\examples{
library(pathviewr)
library(ggplot2)
library(magrittr)

if (interactive()) {
  ## Import the example Motive data included in the package
  motive_data <-
    read_motive_csv(system.file("extdata",
                                "pathviewr_motive_example_data.csv",
                                package = 'pathviewr'))

  ## Clean, isolate, and label trajectories
  motive_full <-
    motive_data \%>\%
    clean_viewr(desired_percent = 50,
                max_frame_gap = "autodetect",
                span = 0.95)

  ## Plot all trajectories by subject
  motive_full \%>\%
    plot_by_subject()

  ## Add treatment information
  motive_full$treatment <- c(rep("latA", 100), rep("latB", 100),
                             rep("latA", 100), rep("latB", 149))

  ## Plot all trajectories by subject, color by treatment
  motive_full \%>\%
    plot_by_subject(col_by_treat = TRUE)
}
}
\seealso{
Other plotting functions: 
\code{\link{plot_viewr_trajectories}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Melissa S. Armstrong
}
\concept{plotting functions}
