#  Copyright © 2018-2025 Commonwealth Scientific and Industrial Research
#  Organisation (CSIRO) ABN 41 687 119 230.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.


#' FHIR MIME types
#'
#' The following MIME types are supported:
#' \itemize{
#'   \item{\code{FHIR_JSON}: FHIR resources encoded as JSON}
#'   \item{\code{FHIR_XML}: FHIR resources encoded as XML}
#' }
#' 
#' @seealso \href{https://hl7.org/fhir/R4/formats.html}{FHIR R4 - Resource Formats}
#'
#' @export
MimeType <- list(
    FHIR_JSON = "application/fhir+json",
    FHIR_XML = "application/fhir+xml"
)

#' FHIR versions
#'
#' The following FHIR versions are supported:
#' \itemize{
#'   \item{\code{R4}: FHIR R4}
#' }
#'
#' @export
Version <- list(
    R4 = "R4"
)
