% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{ds_view}
\alias{ds_view}
\title{Execute a SQL on FHIR view}
\usage{
ds_view(
  ds,
  resource,
  select = NULL,
  constants = NULL,
  where = NULL,
  json = NULL
)
}
\arguments{
\item{ds}{The DataSource object containing the data to be queried.}

\item{resource}{A string representing the type of FHIR resource that the view is based upon, e.g. 'Patient' or 'Observation'.}

\item{select}{A list of columns and nested selects to include in the view. Each element should be a list with appropriate structure.}

\item{constants}{An optional list of constants that can be used in FHIRPath expressions.}

\item{where}{An optional list of FHIRPath expressions that can be used to filter the view.}

\item{json}{An optional JSON string representing the view definition, as an alternative to providing the parameters as R objects.}
}
\value{
A Spark DataFrame containing the results of the view.
}
\description{
Executes a SQL on FHIR view definition and returns the result as a Spark DataFrame.
}
\examples{
\dontrun{
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples('ndjson'))
data_source \%>\% ds_view('Patient',
     select = list(
       list(
         column = list(
           list(path = 'id', name = 'id'),
           list(path = 'gender', name = 'gender'),
           list(path = "telecom.where(system='phone').value", 
                             name = 'phone_numbers', collection = TRUE)
         )
       ),
       list(
         forEach = 'name',
         column = list(
           list(path = 'use', name = 'name_use'),
           list(path = 'family', name = 'family_name')
         ),
         select = list(
           list(
             forEachOrNull = 'given',
             column = list(
               list(path = '$this', name = 'given_name')
             )
           )
         )
       )
     ),
     where = list(
        list(path = "gender = 'male'")
     )
)
}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/running-queries}{Pathling documentation - SQL on FHIR}
}
