% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{get_biogrid_pin}
\alias{get_biogrid_pin}
\title{Retrieve the Requested Release of Organism-specific BioGRID PIN}
\usage{
get_biogrid_pin(org = "Homo_sapiens", path2pin, release = "4.2.191")
}
\arguments{
\item{org}{organism name. BioGRID naming requires underscores for spaces so
"Homo sapiens" becomes "Homo_sapiens", "Mus musculus" becomes "Mus_musculus"
etc. See \url{https://wiki.thebiogrid.org/doku.php/statistics} for a full
list of available organisms (default = "Homo_sapiens")}

\item{path2pin}{the path of the file to save the PIN data. By default, the
PIN data is saved in a temporary file}

\item{release}{the requested BioGRID release (default = "4.2.191")}
}
\value{
the path of the file in which the PIN data was saved. If
\code{path2pin} was not supplied by the user, the PIN data is saved in a
temporary file
}
\description{
Retrieve the Requested Release of Organism-specific BioGRID PIN
}
