% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest-pv-data.R
\name{get_ok_pk}
\alias{get_ok_pk}
\title{Get OK primary key}
\usage{
get_ok_pk(endpoint)
}
\arguments{
\item{endpoint}{The endpoint which you would like to know a potential primary
key for.}
}
\value{
The name of a primary key (\code{pk}) that you could pass to
  \code{\link{unnest_pv_data}}.
}
\description{
This function suggests a value that you could use for the \code{pk} argument
in \code{\link{unnest_pv_data}}, based on the endpoint you searched.
It will return a potential unique identifier for a given entity (i.e., a
given endpoint). For example, it will return "patent_id" when
\code{endpoint = "patents"}.
}
\examples{
get_ok_pk(endpoint = "inventors") # Returns "inventor_id"
get_ok_pk(endpoint = "cpc_subsections") # Returns "cpc_subsection_id"
}
