% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ice_mask.R
\name{make_ice_mask}
\alias{make_ice_mask}
\title{Downscale an ice mask}
\usage{
make_ice_mask(ice_mask_low_res, land_mask_high_res, d = c(0.5, 3))
}
\arguments{
\item{ice_mask_low_res}{a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} of the low resolution ice mask
to downscale (e.g. as obtained with \code{\link[=get_ice_mask]{get_ice_mask()}})}

\item{land_mask_high_res}{a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} of the land masks at different
times (e.g. as obtained from \code{\link[=make_land_mask]{make_land_mask()}}). The ice mask will be cropped
and matched for the resolution of this land mask.}
}
\value{
a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} of the ice mask (1's), with the rest of the
world (sea and land) as NA's
}
\description{
Downscaling the ice mask presents some issues. The mask is a binary raster,
so any standard downscaling approach will still look very blocky. We can
smooth the contour by applying a Gaussian filter. How strong that filter
should be is very much a matter of personal opinion, as we do not have any
data to compare to. This function attempts to use as sensible default value,
but it is worth exploring alternative values to find a good solution.
}
\keyword{internal}
