% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_lon.R
\name{parse_lon}
\alias{parse_lon}
\title{Parse longitude values}
\usage{
parse_lon(lon, format = NULL)
}
\arguments{
\item{lon}{(numeric/integer/character) one or more longitude values.}

\item{format}{(character) format, not implemented yet.}
}
\value{
numeric vector
}
\description{
Parse longitude values
}
\section{Errors}{

Throws warnings on parsing errors, and returns \code{NaN} in each case

Types of errors:
\itemize{
\item invalid argument: e.g., letters passed instead of numbers,
see \url{https://en.cppreference.com/w/cpp/error/invalid_argument}
\item out of range: numbers of out acceptable range, see
\url{https://en.cppreference.com/w/cpp/error/out_of_range}
\item out of longitude range: not within -180/360 range
}
}

\examples{
parse_lon("")
\dontrun{
parse_lon("-181")
parse_lon("-361")
parse_lon("95")
parse_lon("asdfaf")

parse_lon("45")
parse_lon("-45")
parse_lon("-45.2323")
parse_lon("334")

# out of range with std::stod?
parse_lon("-45.23232e24")
parse_lon("-45.23232e2")
parse_lon("-45.23232")

# numeric input
parse_lon(1:10)
parse_lon(85:94)

# different formats
parse_lon("40.4183318 E")
parse_lon("40.4183318 W")
parse_lon("40 25 5.994") # => 40.41833

parse_lon("40.4183318W")
parse_lon("W40.4183318")
parse_lon("E40.4183318")
parse_lon("40.4183318E")

parse_lon("E 39 21.440") # => 39.35733
parse_lon("W 56 1.389") # => -56.02315

parse_lon("E40°25’5.994") # => 40.41833
parse_lon("40° 25´ 5.994\" E") # => 40.41833
parse_lon("40:25:6E")
parse_lon("40:25:5.994E")
parse_lon("40d 25’ 6\" E")
}
}
