% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_partial_time_extract.R
\name{parttime_extract}
\alias{parttime_extract}
\alias{[.partial_time}
\alias{[[.partial_time}
\alias{[<-.partial_time}
\alias{[[<-.partial_time}
\title{Indexing operators for partial_time objects}
\usage{
\method{[}{partial_time}(x, i, j, ...)

\method{[[}{partial_time}(x, i, j, ..., value)

\method{[}{partial_time}(x, i, j, ..., reflow = TRUE) <- value

\method{[[}{partial_time}(x, i, ...) <- value
}
\arguments{
\item{x}{an object from which to extract element(s) or in which to replace
element(s).}

\item{i}{indicies specifying elements to extract or replace. For further
details, see \link[base]{Extract}.}

\item{j}{column indicies specifying element(s) to extract or replace. For
further details, see \link[base]{Extract}.}

\item{...}{arguments unused}

\item{value}{typically an array-like \R object of a similar class as
    \code{x}.}

\item{reflow}{a \code{logical} indicating whether modified data fields should
be reflowed, cascading range overflow. Setting to \code{FALSE} permits
invalid dates, but saves on compute. Generally, it should only be disabled
when multiple calculations are performed back-to-back and the dates only
need to be reflowed once at the end of the calculation.}
}
\value{
A numeric matrix subset of the \code{partial_time} internal matrix
representation. See the Details section of \link{parttime} for further
information.

A \code{numeric} vector of the provided parttime field

the new value of the assigned \code{partial_time} object after
modification.

A \code{partial_time} vector after modification
}
\description{
Indexing operators repurpose matrix indexing for indexing into parttime
fields. When only \code{i} is provided, the \code{parttime} vector is sliced.
Whenever \code{j} is provided, the individual fields are indexed out of an
internal matrix.
}
\examples{
x <- as.parttime(c("2019", "2019-02", "2019-02-02"))
# <partial_time<YMDhms+tz>[3]>
# [1] "2019"       "2019-02"    "2019-02-02"

x[, c(1, 3)]
#            year day
# 2019       2019  NA
# 2019-02    2019  NA
# 2019-02-02 2019   2

x[, "month"]
#       2019    2019-02 2019-02-02
#         NA          2          2

x[, "month", drop = FALSE]
#            month
# 2019          NA
# 2019-02        2
# 2019-02-02     2

x <- as.parttime(c("2019", "2019-02", "2019-02-02"))
# <partial_time<YMDhms+tz>[3]>
# [1] "2019"       "2019-02"    "2019-02-02"

x[c(1, 3)] <- as.parttime(c("2000", "1999"))
# <partial_time<YMDhms+tz>[3]>
# [1] "2000"    "2019-02" "1999"

x[,"month"] <- 3
# <partial_time<YMDhms+tz>[3]>
# [1] "2000-03" "2019-03" "1999-03"

}
