\name{plot.rank_stability}
\alias{plot.rank_stability}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot outouts of PARSEC function \code{\link{rank_stability}}
}
\description{
The function generates four plots to analyse the evolution of the average ranks and positions in the ranking of the profiles associated to the selected posets generated by different alpha-cuts in the posetic FOD analysis.

Rankings and average ranks have to be evaluted with the function \code{\link{rank_stability}}.

First and third plots show the evolution of average ranks, second and fourth show the evolution of rankings. Evolutions in first and second plots are shown as progressions in a sequence of posets, in third and fourth plots evolutions are compared with the alpha values that generate the posets.
}
\usage{
\method{plot}{rank_stability}(x,
    which = 1:4, legend = TRUE, legend.x = "bottomleft",
    legend.y = NULL, legend.bg = "white", grid = TRUE,
    grid.lty = 2, grid.col = rgb(0, 0, 0, 1/7),
    grid.lwd = 1, y_axis = "reversed", ask = dev.interactive(),
    type = "l", col = gray(1:ncol(x$ranking)/ncol(x$ranking)/1.3),
    lwd = 3, lty = 1, ...
)}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
object of class \code{rank_stability} generated by the function \code{\link{rank_stability}}.
}
  \item{which}{if a subset of the plots is required, specify a subset of the numbers 1:4, see caption below (and the 'Details') for the different kinds.
  }
  \item{legend}{
boolean argument to choose whether to show the legend in the plots.
}
  \item{legend.x, legend.y, legend.bg}{
arguments \code{x}, \code{y} and \code{bg} of the function \code{\link{legend}} to define the co-ordinates and the backgroud color of the legend.
}
  \item{grid}{
boolean argument to choose whether to show the grid in the plots.
}
  \item{grid.lty, grid.col, grid.lwd}{
arguments to define line type, color and width of the grid.
}
  \item{y_axis}{if it is set equal to "reversed" plots show the y axis reversed.}
  \item{ask}{
boolean argument indicating whether the system has to ask before changing the plot.
}
  \item{type}{
1-character string giving the type of plot desired. See \code{\link{plot.default}} for details.
}
  \item{col}{
vector of colors. Colors are used cyclically. See \code{\link{matplot}} for details.
}
  \item{lwd}{
vector of line widths. Widths are used cyclically. See \code{\link{matplot}} for details.
}
  \item{lty}{
vector of line types. Types are used cyclically. See \code{\link{matplot}} for details.
}
  \item{\dots}{
other arguments of the function \code{\link{matplot}}.
}
}

\seealso{
\code{\link{rank_stability}}, \code{\link{legend}}, \code{\link{plot.default}}, \code{\link{matplot}}
}
\examples{
v1 <- as.ordered(c("a", "b", "c", "d"))
v2 <- 1:3
prof <- var2prof(varmod = list(v1 = as.ordered(c("a", "b", "c", "d")), v2 = 1:3))
np <- nrow(prof$profiles)

k <- 10 # number of populations
set.seed(0)
populations <- as.data.frame(lapply(1:k, function(x) round(runif(np)*100)))
rownames(populations) <- rownames(prof$profiles)
names(populations) <- paste0("P", 1:k)

x <- FFOD(profiles = prof, distributions = populations)

res <- rank_stability(x)
plot(res)
}