% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_phy.R
\encoding{UTF-8}
\name{convert_phy}
\alias{convert_phy}
\title{Searches health history data for given codes}
\usage{
convert_phy(
  d,
  code = "phy_code",
  code_type = "phy_code_type",
  codes_to_find = NULL,
  collapse = NULL,
  code_time = "time_phy",
  aggr_type = "earliest",
  nThread = parallel::detectCores() - 1
)
}
\arguments{
\item{d}{data.table, database containing health history information data loaded using the \emph{load_phy} function.}

\item{code}{string, column name of the diagnosis code column. Defaults to \emph{phy_code}.}

\item{code_type}{string, column name of the code_type column. Defaults to \emph{phy_code_type}.}

\item{codes_to_find}{list, a list of string arrays corresponding to sets of code types and codes separated by \emph{:}, i.e.: "LMR:3688".
The function searches for the given health history code type and code pair and adds new boolean columns with the name of each list element.
These columns are indicators whether any of the health history code type and code pair occurs in the set of codes.}

\item{collapse}{string, a column name on which to collapse the data.table.
Used in case we wish to assess whether multiple health history codes are present within all the same instances of \emph{collapse}. See vignette for details.}

\item{code_time}{string, column name of the time column. Defaults to \emph{time_phy}. Used in case collapse is present to provide the earliest or latest instance of health history information.}

\item{aggr_type}{string, if multiple health histories are present within the same case of \emph{collapse}, which timepoint to return. Supported are: "earliest" or "latest". Defaults to \emph{earliest}.}

\item{nThread}{integer, number of threads to use for parallelization. If it is set to 1, then no parallel backends are created and the function is executed sequentially.}
}
\value{
data.table, with indicator columns whether the any of the given health histories are reported.
If \emph{collapse} is present, then only unique ID and the summary columns are returned.
}
\description{
Analyzes health history data loaded using \emph{load_phy}. Searches health history columns for a specified set of codes.
By default, the data.table is returned with new columns corresponding to boolean values, whether given group of health history data are present within the respective columns.
If \emph{collapse} is given, then the information is aggregated based-on the \emph{collapse} column and the earliest of latest time of the given diagnosis is provided.
}
\examples{
\dontrun{
#Search for Height and Weight codes
anthropometrics <- list(Weight = c("LMR:3688", "EPIC:WGT"), Height = c("LMR:3771", "EPIC:HGT"))
data_phy_parse <- convert_phy(d = data_phy, codes_to_find = anthropometrics, nThread = 2)

#Search for for Height and Weight codes and summarize per patient providing earliest time
anthropometrics <- list(Weight = c("LMR:3688", "EPIC:WGT"), Height = c("LMR:3771", "EPIC:HGT"))
data_phy_parse <- convert_phy(d = data_phy, codes_to_find = anthropometrics, nThread = 2,
collapse = "ID_MERGE", aggr_type = "earliest")
}
}
