% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_enc.R
\encoding{UTF-8}
\name{convert_enc}
\alias{convert_enc}
\title{Searches columns for given diseases defined by ICD codes.}
\usage{
convert_enc(
  d,
  code = c("enc_diag_admit", "enc_diag_princ", paste0("enc_diag_", 1:10)),
  keep = FALSE,
  codes_to_find = NULL,
  collapse = NULL,
  code_time = "time_enc_admit",
  time_type = "earliest",
  nThread = 4
)
}
\arguments{
\item{d}{data.table, database containing encounter information data loaded using the \emph{load_enc} function.}

\item{code}{string vector, an array of column names to convert to simple ICD codes. The new column names will be the old one with \emph{ICD_} added to the beginning of it.}

\item{keep}{boolean, whether to keep original columns that were converted. Defaults to \emph{FALSE}.}

\item{codes_to_find}{list, a list of arrays corresponding to sets of ICD codes. The function searches the columns in code and new boolean columns with the name of each list element will be created.
These columns are indicators whether the given disease is present in the set of ICD codes or not.}

\item{collapse}{string, a column name on which to collapse the data.table.
Used in case we wish to assess whether given diagnoses are present within all the same instances of \emph{collapse}. See vignette for details.}

\item{code_time}{string, column name of the time column. Defaults to \emph{time_enc_admit}. Used in case collapse is present to provide the earliest or latest instance of diagnosing the given disease.}

\item{time_type}{string, if multiple diagnoses are present within the same case of \emph{collapse}, which timepoint to return. Supported are: "earliest" or "latest". Defaults to \emph{earliest}.}

\item{nThread}{integer, number of threads to use by \emph{dopar} for parallelization. If it is set to 1, then no parallel backends are created and the function is executed sequentially.
On windows machines sockets are used, while on other operating systems fork parallelization is used.}
}
\value{
data.table, with formatted ICD code columns and possibly indicator columns if provided.
If \emph{collapse} is present, then only unique ID and the summary columns are returned.
}
\description{
Analyzes encounter data loaded using \emph{load_enc}. Converts columns with ICD codes and text to simple ICD codes.
If requested, the data.table is returned with new columns corresponding to boolean values, whether given group of diagnoses are present in the given columns.
If \emph{collapse} is given, then the information is aggregated based-on the \emph{collapse} column and the earliest of latest time of the given diagnosis is provided.
}
\examples{
\dontrun{
#Parse encounter ICD columns and keep original ones as well
data_enc_parse <- convert_enc(d = data_enc, keep = TRUE, nThread = 2)

#Parse encounter ICD columns and discard original ones,
#and create indicator variable for the following diseases
diseases <- list(HT = c("I10"), Stroke = c("434.91", "I63.50"))
data_enc_disease <-  convert_enc(d = data_enc, keep = FALSE,
codes_to_find = diseases, nThread = 2)

#Parse encounter ICD columns and discard original ones
#and create indicator variables for the following diseases and summarize per patient,
#whether there are any encounters where the given diseases were registered
diseases <- list(HT = c("I10"), Stroke = c("434.91", "I63.50"))
data_enc_disease <-  convert_enc(d = data_enc, keep = FALSE,
codes_to_find = diseases, nThread = 2, collapse = "ID_MERGE")
}
}
