% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Userfunctions.R
\name{ode_solving}
\alias{ode_solving}
\title{Solves ode-system and compare result to measured states}
\usage{
ode_solving(
  integration_times,
  ode_system,
  relative_tolerance,
  absolute_tolerances,
  start,
  states,
  where_to_save_output_states,
  solvertype
)
}
\arguments{
\item{integration_times}{a vector containing the time course to solve the ode-system (see Details for more Information)}

\item{ode_system}{the ode-system which will be integrated by the solver (see Details for more Information).}

\item{relative_tolerance}{a number defining the relative tolerance used by the ode-solver.}

\item{absolute_tolerances}{a vector containing the absolute tolerance(s) for each state used by the ode-solver.}

\item{start}{a string-path to a tab seperated text-file containing values for the parameters (see Details for more Information).}

\item{states}{a string-path to a tab seperated text-file containing the measured states (see Details for more Information).}

\item{where_to_save_output_states}{a string-path defining a name for a textfile where the result of the integration of the states is saved. Using the previously optimized parameter in this integration.}

\item{solvertype}{a string defines the type of solver which should be used (bdf, ADAMS, ERK or ARK. see Details for more Information).}
}
\description{
ode_solving solves ode system and calculates error between solved and measured values.
}
\details{
The vector containing the time course to solve the ode-system should contain the same entries as the time vector in the text file containing the states (of course it can be also be a different variable instead of time). It is possible that the vector is shorter than the time vector defined in the state-file in order to optimize only a part of the problem.

The ode system should be a Rcpp-function with a specific signature. The name of the function is free to choose. The following parameters have to be passed: a double t, a std::vector<double> params, and a Rcpp::NumericVector y.

The first entry defines the time point when the function is called.

The second argument defines the parameter which should be optimized. There exist two different types of parameters. Parameters can be either constant or variabel. In order to calculate a variable parameter at a specific timepoint the Catmull-Rom-Spline is used. This vector contains the already splined parameters, in the same order as defined in the text-files containing the start-values and the lower- and upper-boundaries.

The last argument is a vector containing the states in the same order as defined in the text-file containing the state-information. Thus, it is obligatory that the state-derivates in the ode-system are in the same order defined as in the text-file.

Furthermore, it is mandatory that the function return a Rcpp::NumericVector with the same dimension as the input vector containing the states. Naturally, the vector should contain the right hand side of the ode-system.

The file containing the start values for the parameter must have the following layout. In the first column the time is defined. In the following columns the parameters are defined. Consider that the parameter order is the same as used in the ode-system.

For constant parameters use only the first row (below the headers) if other parameters are variable use “NA“ in the following rows for the constant parameters.

For variable parameters at least four points are needed. If a variable parameter is not available at every time point use “NA“ instead.

Furthermore, it is notably that the time of the parameter should be within the time vector defined in the text-file containing the state information.

The file containing the state information should contain in the first column the time. The header-name time is compulsory. The following columns contain the states. Take care that the state order is the same as defined in the ode system. If a state is not available use “NA“. This is possible for every time points except the first one. The ode solver need a start value for each state which is extracted from the first row of this file (below the headers).

The error between the solver output and the measured states is the sum of the absolute differences divided by the number of time points. It is crucial that the states are in the same order in the text file cointaining the state-information and in the ode-system to compare the states correctly!

For solving the ode system the SUNDIALS Software is used (https://computing.llnl.gov/projects/sundials). The last argument defines the solver-type which is used during optimization: “bdf“,  “ADAMS“, “ERK“ or “ARK“. bdf = Backward Differentiation Formulas, ADAMS = Adams-Moulton, ERK = explicite Runge-Kutta and ARK = implicite Runge-Kutta. All solvers are used in the NORMAL-Step method in a for-loop using the time-points defined in the text-file containing the states as output-points. The bdf- and ARK-Solver use the SUNLinSol_Dense as linear solver. Notably here is that for the ARK-Solver the ode system is fully implicit solved (not only part of it).
}
\examples{
path <- system.file("examples", package = "paropt")
library(paropt)
#Rcpp::sourceCpp(paste(path,"/ode.cpp", sep = "")) 
#if you want compile ode-system on your system (already precompiled in package)
df <- read.table(paste(path,"/states_LV.txt", sep = ""), header = TRUE)
time <- df$time
param_start <- paste(path, "/start.txt", sep = "")
states <- paste(path, "/states_LV.txt", sep = "")
state_output <- paste(tempdir(), "/final_stateoutput.txt", sep = "")
ode_solving(time, paropt:::ode_example, 1e-6, c(1e-8, 1e-8),
            param_start,
            states,
            state_output, "bdf")
df_in_silico <- read.table(paste(tempdir(), "/final_stateoutput.txt", sep = ""), header = TRUE)
plot(df$time, df$n1, pch = 19, main = "predator", ylab = "predator", xlab = "time")
points(df_in_silico$time, df_in_silico$n1, pch = 19, col = "darkred")
legend(1, 26, legend = c("measured", "in silico"),
       col = c("black", "darkred"),lty = 1:2, cex = 0.8)
plot(df$time, df$n2, pch = 19, main = "prey",ylab = "prey", xlab = "time")
points(df_in_silico$time, df_in_silico$n2, pch = 19, col = "darkred")
legend(1, 26, legend = c("measured", "in silico"),
       col = c("black", "darkred"),lty = 1:2, cex = 0.8)
}
