% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dof_ml1.R, R/p_value_ml1.R, R/se_ml1.R
\name{dof_ml1}
\alias{dof_ml1}
\alias{p_value_ml1}
\alias{se_ml1}
\title{p-values using the "m-l-1" heuristic}
\usage{
dof_ml1(model)

p_value_ml1(model, dof = NULL)

se_ml1(model)
}
\arguments{
\item{model}{A mixed model.}

\item{dof}{Degrees of Freedom.}
}
\value{
The p-values.
}
\description{
Approximation of degrees of freedom based on a "m-l-1" heuristic as suggested by Elff et al. (2019).
}
\details{
Inferential statistics (like p-values, confidence intervals and
standard errors) may be biased in mixed models when the number of clusters
is small (even if the sample size of level-1 units is high). In such cases
it is recommended to approximate a more accurate number of degrees of freedom
for such inferential statitics. The \emph{m-l-1} heuristic is such an approach
that uses a t-distribution with fewer degrees of freedom (\code{dof_ml1}) to
calculate p-values (\code{p_value_ml1}), standard errors (\code{se_ml1})
and confidence intervals (\code{ci(method = "ml1")}).
\strong{Note} that the "m-l-1" heuristic is not applicable for complex
multilevel designs, e.g. with cross-classified clusters. In such cases,
more accurate approaches like the Kenward-Roger approximation (\code{dof_kenward()})
is recommended. However, the "m-l-1" heuristic also applies to generalized
mixed models, while approaches like Kenward-Roger or Satterthwaite are limited
to linear mixed models only.
}
\examples{
\donttest{
library(lme4)
model <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
p_value_ml1(model)
}

}
\references{
Elff, M.; Heisig, J.P.; Schaeffer, M.; Shikano, S. (2019): Multilevel Analysis with Few Clusters: Improving Likelihood-based Methods to Provide Unbiased Estimates and Accurate Inference, British Journal of Political Science.
}
\seealso{
\code{dof_ml1()} and \code{se_ml1()} are small helper-functions
to calculate approximated degrees of freedom and standard errors of model
parameters, based on the "m-l-1" heuristic.
}
