% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterSet_S3methods.R
\name{rep.ParameterSet}
\alias{rep.ParameterSet}
\title{Replicate a ParameterSet}
\usage{
\method{rep}{ParameterSet}(x, times, prefix, ...)
}
\arguments{
\item{x}{(\link{ParameterSet})}

\item{times}{(\code{integer(1)}) \cr
Numer of times to replicate the \code{ParameterSet}.}

\item{prefix}{(\code{character(1)|character(length(times))}) \cr
The prefix to add to ids and linked tags. If length \code{1} then is
internally coerced to \code{paste0(prefix, seq(times))}, otherwise the length
should be equal to \code{times}.}

\item{...}{(\code{ANY}) \cr Other arguments, currently unused.}
}
\description{
In contrast to the \verb{$rep} method in \link{ParameterSet}, this method
deep clones the \link{ParameterSet} and returns a new object.
}
\details{
In order to avoid duplicated parameter ids, every id in the
\link{ParameterSet} is given a \code{prefix} in the format \code{prefix__id}. In
addition, linked tags are also given the same prefix to prevent
incorrectly linking parameters.

The primary use-case of this method is to treat the \link{ParameterSet} as a
collection of identical \link{ParameterSet} objects.
}
