% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{changeRow}
\alias{changeRow}
\title{Row edition}
\usage{
changeRow(id, rowIndex, newValues)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{rowIndex}{index of the changed row.}

\item{newValues}{list of new values to attribute to the row (list associating a value to a column identifier).}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Asks to change a row.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
       sliderInput("rowValueSlider", "Value for 'Sepal.Length' of first row:",
           min = 4, max = 8, step = 0.1, value = iris[["Sepal.Length"]][1]),
       p("The slider controls the new value to assign to the 'Sepal.Length' of the first row"),
       parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
       output$parPlot <- renderParallelPlot({
           parallelPlot(iris)
       })
       observeEvent(input$rowValueSlider, {
           newValues <- iris[1,]
           newValues[["Sepal.Length"]] <- input$rowValueSlider
           parallelPlot::changeRow("parPlot", 1, newValues)
       })
   }

   shinyApp(ui, server)
 }

}
