% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parabar-package.R
\docType{package}
\name{parabar-package}
\alias{parabar}
\alias{parabar-package}
\title{Progress Bar for Parallel Tasks}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

A simple interface in the form of R6 classes for executing tasks in parallel, tracking their progress, and displaying accurate progress bars.
}
\details{
The package is aimed at two audiences: (1) end-users who want to execute a
task in parallel in an interactive \code{R} session and track the execution
progress, and (2) \code{R} package developers who want to use \code{\link{parabar}}
as a
solution for parallel processing in their packages.
}
\section{Users}{

For the first category of users, \code{\link{parabar}} provides seven main
functions of interest:
\itemize{
\item \code{\link[=start_backend]{start_backend()}}: creates a parallel backend for executing tasks
according to the specifications provided.
\item \code{\link[=stop_backend]{stop_backend()}}: stops an active backend and makes the \code{\link[R6:R6Class]{R6::R6}}
eligible for garbage collection.
\item \code{\link[=par_sapply]{par_sapply()}}: is a drop-in replacement for the built-in
\code{\link[base:lapply]{base::sapply()}} function when no backend is provided. However, when a
backend is provided, the function will execute a task in parallel on the
backend, similar to the built-in function \code{\link[parallel:clusterApply]{parallel::parSapply()}}.
\item \code{\link[=clear]{clear()}}: removes all variables available on a backend.
\item \code{\link[=peek]{peek()}}: returns the names of all variables available on a
backend.
\item \code{\link[=export]{export()}}: exports objects from a specified environment to a
backend.
\item \code{\link[=evaluate]{evaluate()}}: evaluates arbitrary and unquoted expression on a
backend.
}

\code{\link{parabar}} also provides a function \code{\link[=configure_bar]{configure_bar()}} for
configuring the progress bar, and three functions can be used to get and set
the package options:
\itemize{
\item \code{\link[=get_option]{get_option()}}: gets the value of a package option.
\item \code{\link[=set_option]{set_option()}}: sets the value of a package option.
\item \code{\link[=set_default_options]{set_default_options()}}: sets default values for all package
options. This function is automatically called on package load.
}
}

\section{Developers}{

For the second category of users, \code{\link{parabar}} provides a set of
classes (i.e., \code{\link[R6:R6Class]{R6::R6Class()}}) that can be used to create backends (i.e.,
synchronous and asynchronous) and interact with them via a simple interface.
From a high-level perspective, the package consists of \strong{\code{backends}} and
\strong{\code{contexts}} in which these backends are employed for executing the tasks
in parallel.
\subsection{Backends}{

A \strong{\code{backend}} represents a set of operations, defined by the
\code{\link{Service}} interface, that can be deployed on a cluster returned by
\code{\link[parallel:makeCluster]{parallel::makeCluster()}}. Backends can be synchronous (i.e.,
\code{\link{SyncBackend}}) or asynchronous (i.e., \code{\link{AsyncBackend}}).
The former will block the execution of the current \code{R} session until the
parallel task is completed, while the latter will return immediately and the
task will be executed in a background \code{R} session.

The \code{\link{Service}} interface defines the following operations:
\code{\link[=Service]{start()}}, \code{\link[=Service]{stop()}},
\code{\link[=Service]{clear()}}, \code{\link[=Service]{peek()}},
\code{\link[=Service]{export()}}, \code{\link[=Service]{evaluate()}},
\code{\link[=Service]{sapply()}}, and \code{\link[=Service]{get_output()}}.

Check out the documentation for \code{\link{Service}} for more information on
each method.
}

\subsection{Contexts}{

A \strong{\code{context}} represents the specific conditions in which the backend
operates. The default, regular \code{\link{Context}} class simply forwards the
call to the corresponding backend method. However, a more complex context can
augment the operation before forwarding the call to the backend. One example
of a complex context is the \code{\link{ProgressDecorator}} class. This class
extends the regular \code{\link{Context}} class and decorates the backend
\code{\link[=Service]{sapply()}} operation to log the progress after each task
execution and display a progress bar.

The following are the main classes provided by \code{parabar}:
\itemize{
\item \code{\link{Service}}: interface for backend operations.
\item \code{\link{Backend}}: abstract class that serves as a base class for all
concrete implementations.
\item \code{\link{SyncBackend}}: synchronous backend extending the abstract
\code{\link{Backend}} class.
\item \code{\link{AsyncBackend}}: asynchronous backend extending the abstract
\code{\link{Backend}} class.
\item \code{\link{Specification}}: backend specification used when starting a
backend.
\item \code{\link{TaskState}}: determine the state of a task deployed to an
asynchronous backend.
\item \code{\link{BackendFactory}}: factory for creating backend objects.
\item \code{\link{Context}}: default context for executing backend operations.
\item \code{\link{ProgressDecorator}}: context for decorating the
\code{\link[=Service]{sapply()}} operation to track and display progress.
\item \code{\link{ContextFactory}}: factory for creating context objects.
}
}
}

\section{Progress Bars}{

\code{\link{parabar}} also exposes several classes for creating and updating
different progress bars, namely:
\itemize{
\item \code{\link{Bar}}: abstract class defining the pure virtual methods to be
implemented by concrete bar classes.
\item \code{\link{BasicBar}}: a simple, but robust, bar created via
\code{\link[utils:txtProgressBar]{utils::txtProgressBar()}} extending the \code{\link{Bar}} abstract class.
\item \code{\link{ModernBar}}: a modern bar created via \code{\link[progress:progress_bar]{progress::progress_bar}}
extending the \link{Bar} abstract class.
\item \code{\link{BarFactory}}: factory for creating bar objects.
}

Finally, \code{\link{parabar}} uses several \code{\link[base:options]{base::options()}} to configure the
behavior of the functionality it provides. For more information on the
options used and their see default values, see the \code{\link{Options}}
class.

For more information about the design of \code{\link{parabar}}, check out the
documentation and the \code{UML} diagram at
\href{https://parabar.mihaiconstantin.com}{parabar.mihaiconstantin.com}.

\if{html}{
\out{<div style="display: block; text-align: center">}

\out{<div style="display: block; margin-top: 1rem; margin-bottom: 0.5rem">}

\strong{Software Design}

\out{</div>}

\figure{parabar-design.png}{options: style="max-width: 95\%;" alt="parabar Software Design"}

\out{</div>}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://parabar.mihaiconstantin.com}
  \item Report bugs at \url{https://github.com/mihaiconstantin/parabar/issues}
}

}
\author{
\strong{Maintainer}: Mihai Constantin \email{mihai@mihaiconstantin.com} (\href{https://orcid.org/0000-0002-6460-0107}{ORCID})

}
\keyword{internal}
