% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvarhk.R
\name{pvarhk}
\alias{pvarhk}
\title{Hank Kuehrsteiner Estimator for PVAR Model}
\usage{
pvarhk(dependent_vars, lags = 1, exog_vars, transformation = c("demean"),
  data, panel_identifier = c(1, 2))
}
\arguments{
\item{dependent_vars}{Dependent variables}

\item{lags}{Number of lags of dependent variables}

\item{exog_vars}{Exogenous variables}

\item{transformation}{Demeaining \code{"demean"}}

\item{data}{Data set}

\item{panel_identifier}{Vector of panel identifiers}
}
\description{
This function estimates a stationary PVAR with fixed effects.
}
\examples{
data(Dahlberg)
ex1_hk <-
pvarhk(dependent_vars = c("expenditures", "revenues", "grants"),
        lags = 1,
        transformation = "demean",
        data = Dahlberg,
        panel_identifier= c("id", "year"))
}
