% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-install.R
\name{pandoc_locate}
\alias{pandoc_locate}
\title{Locate a specific Pandoc version installed with this package}
\usage{
pandoc_locate(version = "default")
}
\arguments{
\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
Path of Pandoc binaries root folder if version is available.
}
\description{
This package helps install and manage Pandoc binaries in a specific folder.
This function helps with finding the path to those specific versions of Pandoc.
See \code{\link[=pandoc_bin]{pandoc_bin()}} for another way of getting paths to \code{pandoc} binaries
}
\examples{
\dontshow{if (pandoc::pandoc_available() && !pandoc::pandoc_is_active("system") && !pandoc::pandoc_is_active("rstudio")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# where is the default active version located ?
pandoc_locate()
\dontshow{\}) # examplesIf}
pandoc::pandoc_is_installed("2.11.4")
# where is a specific installed version located
pandoc_locate("2.11.4")
# return root folder of installed versions
pandoc_locate(NULL)
}
\seealso{
\code{\link[=pandoc_install]{pandoc_install()}}
}
