% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convert.R
\name{Pandoc.convert}
\alias{Pandoc.convert}
\title{Converts Pandoc to other format}
\usage{
Pandoc.convert(f, text, format = "html", open = TRUE, options = "",
  footer = TRUE, proc.time, portable.html = TRUE,
  pandoc.binary = panderOptions("pandoc.binary"))
}
\arguments{
\item{f}{Pandoc's markdown format file path. If URL is provided then the generated file's path is \code{tempfile()} but please bear in mind that this way only images with absolute path would shown up in the document.}

\item{text}{Pandoc's markdown format character vector. Treated as the content of \code{f} file - so the \code{f} parameter is ignored. The generated file's path is \code{tempfile()}.}

\item{format}{required output format. For all possible values here check out Pandoc homepage: \url{http://johnmacfarlane.net/pandoc/}}

\item{open}{try to open converted document with operating system's default program}

\item{options}{optionally passed arguments to Pandoc (instead of \code{pander}'s default)}

\item{footer}{add footer to document with meta-information}

\item{proc.time}{optionally passed number in seconds which would be shown in the generated document's footer}

\item{portable.html}{instead of using local files, rather linking JS/CSS files to an online CDN for portability and including base64-encoded images if converting to \code{HTML} without custom \code{options}}

\item{pandoc.binary}{path to \code{pandoc}'s binary if not found in the path}
}
\value{
Converted file's path.
}
\description{
Calling John MacFarlane's great program to convert specified file (see \code{f} parameter below) or character vector {see \code{text} paramater} to other formats like \code{HTML}, \code{pdf}, \code{docx}, \code{odt} etc.
}
\note{
This function depends on \code{Pandoc} which should be pre-installed on user's machine. See the \code{INSTALL} file of the package.
}
\examples{
\dontrun{
Pandoc.convert(text = c('# Demo', 'with a paragraph'))
Pandoc.convert('http://rapporter.github.io/pander/minimal.md')
## Note: the generated HTML is not showing images with relative path from the above file.
## Based on that `pdf`, `docx` etc. formats would not work! If you want to convert an
## online markdown file to other formats with this function, please pre-process the file
## to have absolute paths instead.
}
}
\references{
John MacFarlane (2012): _Pandoc User's Guide_. \url{http://johnmacfarlane.net/pandoc/README.html}
}

