% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system-requirements.R
\name{local_system_requirements}
\alias{local_system_requirements}
\alias{pkg_system_requirements}
\title{Query system requirements}
\usage{
local_system_requirements(
  os = NULL,
  os_release = NULL,
  root = ".",
  execute = FALSE,
  sudo = execute,
  echo = FALSE
)

pkg_system_requirements(
  package,
  os = NULL,
  os_release = NULL,
  execute = FALSE,
  sudo = execute,
  echo = FALSE
)
}
\arguments{
\item{os, os_release}{The operating system and operating system release
version, e.g. "ubuntu", "debian", "centos", "redhat". See
\url{https://github.com/rstudio/r-system-requirements#operating-systems} for
all full list of supported operating systems.

If \code{NULL}, the default, these will be looked up.}

\item{root}{Path to the package tree.}

\item{execute, sudo}{If \code{execute} is \code{TRUE}, pak will execute the system
commands (if any). If \code{sudo} is \code{TRUE}, pak will prepend the commands with
\href{https://en.wikipedia.org/wiki/Sudo}{sudo}.}

\item{echo}{If \code{echo} is \code{TRUE} and \code{execute} is \code{TRUE}, echo the command output.}

\item{package}{Package names to lookup system requirements for.}
}
\value{
A character vector of commands needed to install the system
requirements for the package.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Note that these functions are now \emph{deprecated}, in favor of
\code{\link[=pkg_sysreqs]{pkg_sysreqs()}} and the \verb{sysreqs_*}  functions, which are more
powerful, as they work for all package sources (packages at Github,
GitLab, URLs, etc.) and they have more detailed output.

Instead of

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_system_requirement("curl")
}\if{html}{\out{</div>}}

call

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_sysreqs("curl")$install_scripts
}\if{html}{\out{</div>}}

and the equivalent of

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_system_requirements()
}\if{html}{\out{</div>}}

is

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_sysreqs("local::.", dependencies = TRUE)$install_script
}\if{html}{\out{</div>}}
}
\details{
Returns a character vector of commands to run that will install system
requirements for the queried operating system.

\code{local_system_requirements()} queries system requirements for a dev package
(and its dependencies) given its \code{root} path.

\code{pkg_system_requirements()} queries system requirements for existing packages
(and their dependencies).
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
local_system_requirements("ubuntu", "20.04")
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pkg_system_requirements("pak", "ubuntu", "20.04")
pkg_system_requirements("pak", "redhat", "7")
pkg_system_requirements("config", "ubuntu", "20.04") # no sys reqs
pkg_system_requirements("curl", "ubuntu", "20.04")
pkg_system_requirements("git2r", "ubuntu", "20.04")
pkg_system_requirements(c("config", "git2r", "curl"), "ubuntu", "20.04")
# queried packages must exist
pkg_system_requirements("iDontExist", "ubuntu", "20.04")
pkg_system_requirements(c("curl", "iDontExist"), "ubuntu", "20.04")
\dontshow{\}) # examplesIf}
}
