% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pak.R
\name{pak}
\alias{pak}
\title{Install specified required packages}
\usage{
pak(pkg = NULL, ...)
}
\arguments{
\item{pkg}{Package names or remote package specifications to install.
See \link[=Package sources]{pak package sources} for details. If \code{NULL},
will install all development dependencies for the current package.}

\item{...}{Extra arguments are passed to \code{\link[=pkg_install]{pkg_install()}} or
\code{\link[=local_install_dev_deps]{local_install_dev_deps()}}.}
}
\description{
Install the specified packages, or the ones required by
the package or project in the current working directory.
}
\details{
This is a convenience function:
\itemize{
\item If you want to install some packages, it is easier to type
than \code{\link[=pkg_install]{pkg_install()}}.
\item If you want to install all the packages that are needed
for the development of a package or project, then it is
easier to type than \code{\link[=local_install_dev_deps]{local_install_dev_deps()}}.
\item You don't need to remember two functions to install
packages, just one.
}
}
\seealso{
Other package functions: 
\code{\link{lib_status}()},
\code{\link{pkg_deps_tree}()},
\code{\link{pkg_deps}()},
\code{\link{pkg_download}()},
\code{\link{pkg_install}()},
\code{\link{pkg_remove}()},
\code{\link{pkg_status}()}

Other local package trees: 
\code{\link{local_deps_explain}()},
\code{\link{local_deps}()},
\code{\link{local_install_deps}()},
\code{\link{local_install_dev_deps}()},
\code{\link{local_install}()},
\code{\link{local_package_trees}}
}
\concept{local package trees}
\concept{package functions}
