% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PgR6M.R
\name{PgR6M}
\alias{PgR6M}
\title{PgR6 class with methods.}
\description{
PgR6 with Methods. Final users should use \code{\link{pagoo}}
instead of this, since is more easy to understand.
Inherits: \code{\link[pagoo]{PgR6}}
}
\section{Super class}{
\code{\link[pagoo:PgR6]{pagoo::PgR6}} -> \code{PgR6M}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PgR6M$new()}}
\item \href{#method-rarefact}{\code{PgR6M$rarefact()}}
\item \href{#method-dist}{\code{PgR6M$dist()}}
\item \href{#method-pan_pca}{\code{PgR6M$pan_pca()}}
\item \href{#method-pg_power_law_fit}{\code{PgR6M$pg_power_law_fit()}}
\item \href{#method-cg_exp_decay_fit}{\code{PgR6M$cg_exp_decay_fit()}}
\item \href{#method-gg_barplot}{\code{PgR6M$gg_barplot()}}
\item \href{#method-gg_binmap}{\code{PgR6M$gg_binmap()}}
\item \href{#method-gg_dist}{\code{PgR6M$gg_dist()}}
\item \href{#method-gg_pca}{\code{PgR6M$gg_pca()}}
\item \href{#method-gg_pie}{\code{PgR6M$gg_pie()}}
\item \href{#method-gg_curves}{\code{PgR6M$gg_curves()}}
\item \href{#method-runShinyApp}{\code{PgR6M$runShinyApp()}}
\item \href{#method-clone}{\code{PgR6M$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="add_metadata">}\href{../../pagoo/html/PgR6.html#method-add_metadata}{\code{pagoo::PgR6$add_metadata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="drop">}\href{../../pagoo/html/PgR6.html#method-drop}{\code{pagoo::PgR6$drop()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="recover">}\href{../../pagoo/html/PgR6.html#method-recover}{\code{pagoo::PgR6$recover()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="save_pangenomeRDS">}\href{../../pagoo/html/PgR6.html#method-save_pangenomeRDS}{\code{pagoo::PgR6$save_pangenomeRDS()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="write_pangenome">}\href{../../pagoo/html/PgR6.html#method-write_pangenome}{\code{pagoo::PgR6$write_pangenome()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{PgR6M} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$new(
  data,
  org_meta,
  cluster_meta,
  core_level = 95,
  sep = "__",
  verbose = TRUE,
  DF,
  group_meta
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}} containing at least the
following columns: \code{gene} (gene name), \code{org} (organism name to which the gene belongs to),
and \code{cluster} (group of orthologous to which the gene belongs to). More columns can be added as metadata
for each gene.}

\item{\code{org_meta}}{(optional) A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}}
containing additional metadata for organisms. This \code{data.frame} must have a column named "org" with
valid organisms names (that is, they should match with those provided in \code{data}, column \code{org}), and
additional columns will be used as metadata. Each row should correspond to each organism.}

\item{\code{cluster_meta}}{(optional) A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}}
containing additional metadata for clusters. This \code{data.frame} must have a column named "cluster" with
valid organisms names (that is, they should match with those provided in \code{data}, column \code{cluster}), and
additional columns will be used as metadata. Each row should correspond to each cluster.}

\item{\code{core_level}}{The initial core_level (that's the percentage of organisms a core cluster must be in to be
considered as part of the core genome). Must be a number between 100 and 85, (default: 95). You can change it
later by using the \code{$core_level} field once the object was created.}

\item{\code{sep}}{A separator. By default is '__'(two underscores). It will be used to
create a unique \code{gid} (gene identifier) for each gene. \code{gid}s are created by pasting
\code{org} to \code{gene}, separated by \code{sep}.}

\item{\code{verbose}}{\code{logical}. Whether to display progress messages when loading class.}

\item{\code{DF}}{Deprecated. Use \code{data} instead.}

\item{\code{group_meta}}{Deprecated. Use \code{cluster_meta} instead.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An R6 object of class PgR6M. It contains basic fields and methods for analyzing a pangenome. It also
contains additional statistical methods for analyze it, and methods to make basic
exploratory plots.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rarefact"></a>}}
\if{latex}{\out{\hypertarget{method-rarefact}{}}}
\subsection{Method \code{rarefact()}}{
Rarefact pangenome or corgenome. Compute the number of genes which belong to
the pangenome or to the coregenome, for a number of random permutations of
increasingly bigger sample of genomes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$rarefact(what = "pangenome", n.perm = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{One of \code{"pangenome"} or \code{"coregenome"}.}

\item{\code{n.perm}}{The number of permutations to compute (default: 10).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{matrix}, rows are the number of genomes added, columns are
permutations, and the cell number is the number of genes in each category.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dist"></a>}}
\if{latex}{\out{\hypertarget{method-dist}{}}}
\subsection{Method \code{dist()}}{
Compute distance between all pairs of genomes. The default dist method is
\code{"bray"} (Bray-Curtis distance). Another used distance method is \code{"jaccard"},
but you should set \code{binary = FALSE} (see below) to obtain a meaningful result.
See \code{\link[vegan]{vegdist}} for details, this is just a wrapper function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$dist(
  method = "bray",
  binary = FALSE,
  diag = FALSE,
  upper = FALSE,
  na.rm = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{The distance method to use. See \link[vegan]{vegdist}
for available methods, and details for each one.}

\item{\code{binary}}{Transform abundance matrix into a presence/absence
matrix before computing distance.}

\item{\code{diag}}{Compute diagonals.}

\item{\code{upper}}{Return only the upper diagonal.}

\item{\code{na.rm}}{Pairwise deletion of missing observations when
computing dissimilarities.}

\item{\code{...}}{Other parameters. See \link[vegan]{vegdist} for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{dist} object containing all pairwise dissimilarities between genomes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pan_pca"></a>}}
\if{latex}{\out{\hypertarget{method-pan_pca}{}}}
\subsection{Method \code{pan_pca()}}{
Performs a principal components analysis on the panmatrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$pan_pca(center = TRUE, scale. = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{center}}{a logical value indicating whether the variables should be shifted
to be zero centered. Alternately, a vector of length equal the number of columns of x can be
supplied. The value is passed to scale.}

\item{\code{scale.}}{a logical value indicating whether the variables should be scaled
to have unit variance before the analysis takes place. The default is TRUE.}

\item{\code{...}}{Other arguments. See \link[stats]{prcomp}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a list with class "prcomp". See \link[stats]{prcomp} for more information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pg_power_law_fit"></a>}}
\if{latex}{\out{\hypertarget{method-pg_power_law_fit}{}}}
\subsection{Method \code{pg_power_law_fit()}}{
Fits a power law curve for the pangenome rarefaction simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$pg_power_law_fit(raref, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raref}}{(Optional) A rarefaction matrix, as returned by \code{rarefact()}.}

\item{\code{...}}{Further arguments to be passed to \code{rarefact()}. If \code{raref}
is missing, it will be computed with default arguments, or with the ones provided here.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{list} of two elements: \code{$formula} with a fitted function, and \code{$params}
with fitted parameters. An attribute \code{"alpha"} is also returned (If
\code{alpha>1}, then the pangenome is closed, otherwise is open.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cg_exp_decay_fit"></a>}}
\if{latex}{\out{\hypertarget{method-cg_exp_decay_fit}{}}}
\subsection{Method \code{cg_exp_decay_fit()}}{
Fits an exponential decay curve for the coregenome rarefaction simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$cg_exp_decay_fit(raref, pcounts = 10, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raref}}{(Optional) A rarefaction matrix, as returned by \code{rarefact()}.}

\item{\code{pcounts}}{An integer of pseudo-counts. This is used to better fit the function
at small numbers, as the linearization method requires to subtract a constant C, which is the
coregenome size, from \code{y}. As \code{y} becomes closer to the coregenome size, this operation
tends to 0, and its logarithm goes crazy. By default \code{pcounts=10}.}

\item{\code{...}}{Further arguments to be passed to \code{rarefact()}. If \code{raref}
is missing, it will be computed with default arguments, or with the ones provided here.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{list} of two elements: \code{$formula} with a fitted function, and \code{$params}
with fitted intercept and decay parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gg_barplot"></a>}}
\if{latex}{\out{\hypertarget{method-gg_barplot}{}}}
\subsection{Method \code{gg_barplot()}}{
Plot a barplot with the frequency of genes within the total number of
genomes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$gg_barplot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A barplot, and a \code{gg} object (\code{ggplot2} package) invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gg_binmap"></a>}}
\if{latex}{\out{\hypertarget{method-gg_binmap}{}}}
\subsection{Method \code{gg_binmap()}}{
Plot a pangenome binary map representing the presence/absence of each
gene within each organism.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$gg_binmap()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A binary map (\code{ggplot2::geom_raster()}), and a \code{gg} object (\code{ggplot2}
package) invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gg_dist"></a>}}
\if{latex}{\out{\hypertarget{method-gg_dist}{}}}
\subsection{Method \code{gg_dist()}}{
Plot a heatmap showing the computed distance between all pairs of organisms.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$gg_dist(method = "bray", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{Distance method. One of "Jaccard" (default), or "Manhattan",
see above.}

\item{\code{...}}{More arguments to be passed to \code{\link[micropan]{distManhattan}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A heatmap (\code{ggplot2::geom_tile()}), and a \code{gg} object (\code{ggplot2}
package) invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gg_pca"></a>}}
\if{latex}{\out{\hypertarget{method-gg_pca}{}}}
\subsection{Method \code{gg_pca()}}{
Plot a scatter plot of a Principal Components Analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$gg_pca(colour = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{colour}}{The name of the column in \code{$organisms} field from which points will take
colour (if provided). \code{NULL} (default) renders black points.}

\item{\code{...}}{More arguments to be passed to \code{ggplot2::autoplot()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A scatter plot (\code{ggplot2::autoplot()}), and a \code{gg} object (\code{ggplot2}
package) invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gg_pie"></a>}}
\if{latex}{\out{\hypertarget{method-gg_pie}{}}}
\subsection{Method \code{gg_pie()}}{
Plot a pie chart showing the number of clusters of each pangenome category: core,
shell, or cloud.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$gg_pie()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A pie chart (\code{ggplot2::geom_bar() + coord_polar()}), and a \code{gg} object
(\code{ggplot2} package) invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gg_curves"></a>}}
\if{latex}{\out{\hypertarget{method-gg_curves}{}}}
\subsection{Method \code{gg_curves()}}{
Plot pangenome and/or coregenome curves with the fitted functions returned by \code{pg_power_law_fit()}
 and \code{cg_exp_decay_fit()}. You can add points by adding \code{+ geom_points()}, of ggplot2 package
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$gg_curves(what = c("pangenome", "coregenome"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{One of \code{"pangenome"} or \code{"coregenome"}.}

\item{\code{...}}{????}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A scatter plot, and a \code{gg} object (\code{ggplot2} package) invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runShinyApp"></a>}}
\if{latex}{\out{\hypertarget{method-runShinyApp}{}}}
\subsection{Method \code{runShinyApp()}}{
Launch an interactive shiny app. It contains a sidebar
with controls and switches to interact with the pagoo
object. You can drop/recover organisms from the dataset,
modify the core_level, visualize statistics, plots, and
browse cluster and gene information. In the main body, it
contains 2 tabs to switch between summary statistics plots
and core genome information on one side, and accessory
genome plots and information on the other.

The lower part of each tab contains two tables, side by
side. On the "Summary" tab, the left one contain
information about core clusters, with one cluster per row.
When one of them is selected (click), the one on the right
is updated to show information about its genes (if
provided), one gene per row. On the "Accessory" tab, a
similar configuration is shown, but on this case only
accessory clusters/genes are displayed. There is a slider
on the sidebar where one can select the accessory
frequency range to display.

Give it a try!

Take into account that big pangenomes can slow down the
performance of the app. More than 50-70 organisms often
leads to a delay in the update of the plots/tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$runShinyApp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6M$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
