% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelineHelpers.R
\name{make.p2.app}
\alias{make.p2.app}
\title{Generate a Rook Server app from a 'Pagoda2' object. 
This generates a 'pagoda2' web object from a 'Pagoda2' object by automating steps that most
users will want to run. This function is a wrapper about the 'pagoda2' web constructor. 
(Advanced users may wish to use that constructor directly.)}
\usage{
make.p2.app(
  r,
  dendrogramCellGroups,
  additionalMetadata = list(),
  geneSets,
  show.depth = TRUE,
  show.batch = TRUE,
  show.clusters = TRUE,
  appname = "Pagoda2 Application",
  innerOrder = NULL,
  orderDend = FALSE,
  appmetadata = NULL
)
}
\arguments{
\item{r}{a 'Pagoda2' object}

\item{dendrogramCellGroups}{a named factor of cell groups, used to generate the main dendrogram, limits zoom in}

\item{additionalMetadata}{a list of metadata other than depth, batch and cluster that are automatically added (default=list())}

\item{geneSets}{a list of genesets to show}

\item{show.depth}{boolean Include depth as a metadata row (default=TRUE)}

\item{show.batch}{boolean Include batch as a metadata row (default=TRUE)}

\item{show.clusters}{boolean Include clusters as a metadata row (default=TRUE)}

\item{appname}{character Application name (default="Pagoda2 Application")}

\item{innerOrder}{Ordering of cells inside the clusters provided in dendrogramCellGroups (default=NULL). This should be one of "odPCA", "reductdist", "graphbased", "knn". Defaults to NULL}

\item{orderDend}{boolean Whether to order dendrogram (default=FALSE)}

\item{appmetadata}{a 'pagoda2' web application metadata (default=NULL)}
}
\value{
a 'pagoda2' web object that presents a Rook compatible interface
}
\description{
Generate a Rook Server app from a 'Pagoda2' object. 
This generates a 'pagoda2' web object from a 'Pagoda2' object by automating steps that most
users will want to run. This function is a wrapper about the 'pagoda2' web constructor. 
(Advanced users may wish to use that constructor directly.)
}
