% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{plot_trajectory}
\alias{plot_trajectory}
\title{Create a trajectory plot}
\usage{
plot_trajectory(data, center_y = FALSE, perc_y_scale = FALSE)
}
\arguments{
\item{data}{A data frame like the outputs of \code{prep_trajectory()}.
\itemize{
\item (Optional) If present, the column \code{label} is used for data labels.
}}

\item{center_y}{Logical. Use \code{TRUE} to center the y-axis around start value
(the default behavior of \code{qplot_trajectory()}), or use \code{FALSE} to not
center.}

\item{perc_y_scale}{Logical. \code{FALSE} defaults to using no label conversion.
Use \code{TRUE} to convert labels on y-axis to percentage using
\code{scales::percent} (the default behavior of \code{qplot_trajectory()}).}
}
\value{
An object of class "ggplot".
}
\description{
Create a trajectory plot
}
\examples{
# plot with `qplot_trajectory()` parameters
data <- subset(
  market_share,
  sector == "power" &
    technology == "renewablescap" &
    region == "global" &
    scenario_source == "demo_2020"
)
data <- prep_trajectory(data)

plot_trajectory(
  data,
  center_y = TRUE,
  perc_y_scale = TRUE
)
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_techmix}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_techmix}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
