
# double-check that we're in the packrat root directory
if (!file.exists("DESCRIPTION"))
  stop("script must be run from packrat root directory")

desc <- read.dcf("DESCRIPTION", all = TRUE)
if (!identical(desc$Package, "packrat"))
  stop("script must be run from packrat root directory")

# move to temporary directory
owd <- setwd(tempdir())

# check out the latest renv sources
# TODO: clone a specific version / tag
system("git clone --depth 1 https://github.com/rstudio/renv")

twd <- setwd("renv")
gitCommitHash <- system("git rev-parse HEAD", intern = TRUE)
setwd(twd)

# get renv version
desc <- read.dcf("renv/DESCRIPTION", all = TRUE)

# list all of the package's R files
files <- list.files("renv/R", full.names = TRUE)

# concatenate into single file
contents <- unlist(lapply(files, readLines))

# write a header
header <- c(
  "#",
  "# Auto-generated by 'tools/tools-sync-renv.R'.",
  sprintf("# renv (%s %s)", desc$Version, gitCommitHash),
  "#"
)

all <- c(header, contents)

# write to renv helper file
outfile <- file.path(owd, "inst/resources/renv.R")
writeLines(all, con = outfile)

message("* '", outfile, "' has been updated.")
setwd(owd)
