% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcmdcheck.R
\name{eval_from_log}
\alias{eval_from_log}
\title{Evaluate a File's Tagged Lines}
\usage{
eval_from_log(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link{grep_log}}.}
}
\value{
The object obtained by evaluating the file.
}
\description{
Just a wrapper for evaluating the tagged code obtained via
\code{\link{grep_log}}.
\code{\link[rcmdcheck:rcmdcheck]{rcmdcheck::rcmdcheck}} are
\code{\link{cat}}ed so we can evaluate them from reading logs (on
\verb{gitlab}, for
example)
}
\examples{
sink_file <- tempfile()
sink(sink_file)
packager:::write_info()
sink()
grep_log(sink_file, pattern = "=== packager info:")
info <- eval_from_log(sink_file, pattern = "=== packager info:")
\dontrun{
# We need "." to be a package directory, and it takes quite some time.
sink_file <- tempfile()
sink(sink_file)
rcmdcheck_and_log(".")
sink()
rcmdcheck <- eval_from_log(sink_file, pattern = "=== packager rcmdcheck:")
}
}
\keyword{internal}
