% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_parameter_estimation_functions.R
\name{check_estimate_required_params}
\alias{check_estimate_required_params}
\title{Function to check if the parameters are sufficient to define a distribution
and if not see if we can estimate the parameters from the given parameters,
e.g. for gamma distribution, shape and rate can be estimated from mean and sd}
\usage{
check_estimate_required_params(the_expr, distr_key)
}
\arguments{
\item{the_expr}{the expression that contain the definition}

\item{distr_key}{the keyword used to generate random numbers in stats package}
}
\value{
the parameters required
}
\description{
Function to check if the parameters are sufficient to define a distribution
and if not see if we can estimate the parameters from the given parameters,
e.g. for gamma distribution, shape and rate can be estimated from mean and sd
}
\details{
if the distribution is gamma and the parameters are mean and sd
we can estimate shape and rate from mean and sd.
This function is not usually needed by the user
}
\examples{
check_estimate_required_params("gamma(mean = 10 ,sd = 1)", "gamma")
}
\keyword{internal}
