% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occurrences.R
\name{occurrences}
\alias{occurrences}
\title{Occurrence}
\usage{
occurrences(data, n = 5L)
}
\arguments{
\item{data}{A \code{data.frame} wit}

\item{n}{the minimum number of occurrences.}
}
\value{
a \code{data.frame} with six columns: \code{taxon}, \code{Class},
\code{Order}, \code{Family}, \code{Genus}, and \code{count}.
}
\description{
Generate a taxonomic data set with codes which have at least n occurrences.
}
\details{
Of the codes with at least n occurrences, the code with the most taxonomic
detail needs to be selected for the \code{\link[TITAN2]{titan}} run.  This
means if the macroinvertebrate count has at least n occurrences in a genus
code, the family, order, and class codes associated with these counts should
be removed.  Or, for another example, if there are too few counts at the
genus level, but at least n counts at the family level- the family code would
be retained and the order and class codes would be removed.

Coding: All of the macroinvertebrates were coded so the first two letters
indicate the class, the second two letters indicate the order, the third two
letters indicate the family, and the last two numbers indicate the genus.
"00" indicates that there is no information at that level.  For example: A
code that is 'Bi000000' is the Bivalvia class, while BiVe0000 is the Bivalvia
class, Veneroida order. BiVeSh00 is the Bivalvia class, Veneroida order,
Spheriridae family. BiVeSh01 is a genus within that family.

NOTE: The example script that inspired the development of this function
required the data set to have the column names in alpha order.  This function
relaxes that requirement by using the \code{\link[dplyr]{arrange}} call.
}
\examples{

# Report the tax with minimum of five (default) occurrences.
occurrences(CN_06_Mall_wID[, -1])

# Report the tax with at least six occurrences
occurrences(CN_06_Mall_wID[, -1], n = 6)

}
\seealso{
\code{vignette(topic = "pTITAN2", package = "pTITAN2")}
}
