% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCODE.R
\name{tunelambda}
\alias{tunelambda}
\title{Find optimial penalty parameter lambda by cross-validation.}
\usage{
tunelambda(data, time, ode.model, par.names, state.names,
                  par.initial, basis.list,lambda_grid,cv_portion,kfolds, rep,controls)
}
\arguments{
\item{data}{A data frame or matrix contrain observations from each dimension of the ODE model.}

\item{time}{The vector contain observation times or a matrix if time points are different between dimensions.}

\item{ode.model}{Defined R function that computes the time derivative of the ODE model given observations of states variable.}

\item{par.names}{The names of structural parameters defined in the 'ode.model'.}

\item{state.names}{The names of state variables defined in the 'ode.model'.}

\item{par.initial}{Initial value of structural parameters to be optimized.}

\item{basis.list}{A list of basis objects for smoothing each dimension's observations. Can be the same or different across dimensions.}

\item{lambda_grid}{A search grid for finding the optimial sparsity parameter lambda.}

\item{cv_portion}{A number indicating the proportion of data will be saved for doing cross validation. Default is set at 5 as minimum.}

\item{kfolds}{A number indicating the number of folds the data should be seprated into.}

\item{rep}{A integer controls the number of replication of doing cross-validation for each penalty parameter.}

\item{controls}{A list of control parameters. See ‘Details’.}
}
\value{
\item{lambda_grid}{The original input vector of a search grid for the optimal lambda.}

\item{cv.score}{The matrix contains the cross validation score for each lambda of each replication}
}
\description{
Obtain the optimal sparsity parameter given a search grid based on cross validation score with replications.
}
