% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{owmr}
\alias{owmr}
\title{owmr - An R interface to access OpenWeatherMap's API}
\description{
In order to access the API, you need to sign up for an API key
at \url{https://openweathermap.org/}. \cr
For optional parameters (\code{...}) in functions see
\url{https://openweathermap.org/api/}
}
\examples{
\dontrun{
   # first of all you have to set up your api key
   owmr_settings("your_api_key")

   # get current weather data for "Kassel" with temperatures in °C
   get_current("Kassel", units = "metric")

   # get 3h forcast data (7 rows)
   get_forecast("London", cnt = 7)

   # ...
}

}

