% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_owid.R
\name{scale_fill_owid}
\alias{scale_fill_owid}
\alias{scale_colour_owid}
\alias{scale_color_owid}
\title{Our World in Data Colour Scales}
\usage{
scale_fill_owid(alpha = 1, ...)

scale_colour_owid(alpha = 1, ...)

scale_color_owid(alpha = 1, ...)
}
\arguments{
\item{alpha}{Transparency level, a real number in (0, 1).}

\item{...}{additional parameters for \code{\link[ggplot2]{discrete_scale}}}
}
\value{
A ggproto object to be used in the context of ggplot2.
}
\description{
Our World in Data Colour Scales
}
\examples{
\donttest{
library(ggplot2)
library(dplyr)
library(ggrepel)

# make an Our World in Data style chart

venom <- owid("incidence-of-venomous-animal-contact")

venom \%>\%
  filter(entity == c("India", "Australia", "United States")) \%>\%
  group_by(entity) \%>\%
  mutate(label = ifelse(year == max(year), entity, NA)) \%>\%
  ggplot(aes(x = year,
             y = `Incidence - Venomous animal contact - Sex: Both - Age: Age-standardized (Rate)`,
             colour = entity)) +
  geom_line() +
  geom_point(size = 1) +
  geom_text_repel(aes(label = label),
                  hjust = 0, xlim = Inf,
                  na.rm = TRUE, segment.colour = "grey") +
  coord_cartesian(clip = "off")  +
  scale_colour_owid() +
  scale_y_continuous(limits = c(0, 1000)) +
  labs(title = "Incidence of venomous animal contact, 1990 to 2017",
       x = "", y = "") +
  theme_owid() +
  theme(plot.margin = margin(5, 80, 5, 10), legend.position = "none",
        panel.grid.major.x = element_blank())
}


}
