% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_order.R
\name{CalcR2}
\alias{CalcR2}
\title{Calculates R2 of a numerical variable using date as the predictor}
\usage{
CalcR2(myVar, dataFl, dateNm, weightNm = NULL, imputeValue = NULL)
}
\arguments{
\item{myVar}{Name of variable to model.}

\item{dataFl}{A \code{data.table}, containing \code{myVar}, \code{dateNm}, 
and \code{weightNm}.}

\item{dateNm}{Name of column containing the date variable (to be modeled as
numeric); this date column must not have NA's.}

\item{weightNm}{Name of column containing row weights. If weights equal one, 
then the \code{\link{lm.fit}} function will be called, otherwise the 
\code{\link{lm.wfit}} will be called. The weights column must not have NA's.}

\item{imputeValue}{Either \code{NULL} or numeric. If \code{NULL}, model will
be fit on only non-NA components of \code{myVar}. If numeric, missing cases
of \code{myVar} will be imputed to \code{imputeValue}.}
}
\value{
A numeric value of R2.
}
\description{
Calculates weighted R2 of a univariate weighted linear model with
\code{dateNm} as x and \code{myVar} as y using the workhorse \code{lm.fit}
and \code{lm.wfit} functions.
}
\section{License}{

Copyright 2017 Capital One Services, LLC Licensed under the Apache License,
Version 2.0 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the  License at
http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
or agreed to in writing, software distributed under the License is 
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
KIND, either express or implied. See the License for the specific language 
governing permissions and limitations under the License.
}

\seealso{
Functions depend on this function:
         \code{\link{OrderByR2}}.

This function depends on:
         \code{\link{PrepData}}.
}
